<?php
/* 
This file is part of HeatMap Theme Pro v5
Copyright: Stuart Wider
Website: HeatMapTheme.com
*/

/* Set up Sidebars and Widgets
-------------------------------------------------------------- */

function hmt_register_widgets () {
	
	global $themename, $shortname, $options, $baseversion, $thisversion, $subtitle,  $hmt_theme_init;
	
	if (function_exists('wp_register_sidebar_widget')) {
			
		foreach ($options as $value) { 		// Loop through the options array looking for ad widgets.
			switch ( $value['type'] ) {		// When the details of an ad widget is found then grab its name and description and register it.
				case "ad-combo":
					
					$this_option = hmt4_get_option($value['id']);
					
					if ($this_option != "") {
						
						$this_name = hmt4_get_option($value['id'] . '_name');
						if ($this_name=="") $this_name=$value['name'];
					
						$widget_ops = array('description' => $value['widgetdesc']);	
						wp_register_sidebar_widget($value['slug'], $this_name, $value['function'], $widget_ops);  
						wp_register_widget_control( $value['slug'],$this_name, $value['function'] . '_controller', null, 75, $value['slug']);
					}
			}
		}  
		
		// Now register a couple of custom HeatMap Theme widgets

		$widget_ops = array('description' => __("FeedBurner Email Subscription",'hmth') . " (HeatMap Theme v" . $baseversion . ")");
		wp_register_sidebar_widget($shortname.'-feedburner-subscription','FeedBurner', $shortname.'_widget_feedburner', $widget_ops);
		wp_register_widget_control( $shortname.'-feedburner-subscription','FeedBurner', $shortname.'_widget_feedburner_controller', null, 75, $shortname.'-feedburner-subscription');
		
		$widget_ops = array('description' => __("Recent Posts PLUS Thumbnails",'hmth') . " (HeatMap Theme v" . $baseversion . ")");
		wp_register_sidebar_widget($shortname.'-recent-posts-plus','Recent Posts PLUS', $shortname.'_widget_recent_posts_plus', $widget_ops); 
		wp_register_widget_control( $shortname.'-recent-posts-plus','Recent Posts PLUS', $shortname.'_widget_recent_posts_plus_controller', null, 75, $shortname.'-recent-posts-plus');
		
		$widget_ops = array('description' => __("RSS Icons",'hmth') . " (HeatMap Theme v" . $baseversion . ")");
		wp_register_sidebar_widget($shortname.'-widget-rss-icons','RSS Icons', $shortname.'_widget_rss_icons', $widget_ops); 
		wp_register_widget_control( $shortname.'-widget-rss-icons','RSS Icons', $shortname.'_widget_rss_icons_controller', null, 75, $shortname.'-widget-rss-icons');

		// .. and here comes the registration of the 'sidebars' into which all those lovely widgets will be placed	
			
		register_sidebar(
			array(
			'name' => __('[Widebar] 125 - 125px ads','hmth'),
			'id' => 'widebar125',
			'before_widget' => '<!-- %2$s --><span id="%1$s" class="widebar-125 widget %2$s">',
			'after_widget' => '</span>',
			'before_title' => '',
			'after_title' => '',
			)
		);

		register_sidebar(
			array(
			'name' => __('[Widebar] Top - ads/std','hmth'),
			'id' => 'sidebar-1',
			'before_widget' => '<!-- %2$s --><li id="%1$s" class="widebar-top widget %2$s">',
			'after_widget' => '</li>',
			'before_title' => '<h4 class="widgettitle">',
			'after_title' => '</h4>',
			)
		);
		
		register_sidebar(
			array(
			'name' => __('[Widebar] Bottom - ads/std','hmth'),
			'id' => 'sidebar-2', 
			'before_widget' => '<!-- %2$s --><li id="%1$s" class="widebar-bottom widget %2$s">',
			'after_widget' => '</li>',
			'before_title' => '<h4 class="widgettitle">',
			'after_title' => '</h4>',
			)
		);
		
		register_sidebar(
			array(
			'name' => __('[Sidebar] Left - ads/std', 'hmth'),
			'id' => 'sidebar-3',
			'before_widget' => '<!-- %2$s --><li id="%1$s" class="sidebar-left widget %2$s">',
			'after_widget' => '</li>',
			'before_title' => '<h4 class="widgettitle">',
			'after_title' => '</h4>'
			)
		); 
		
		register_sidebar(
			array(
			'name' => __('[Sidebar] Right - ads/std','hmth'),
			'id' => 'sidebar-4',
			'before_widget' => '<!-- %2$s --><li id="%1$s" class="sidebar-right widget %2$s">',
			'after_widget' => '</li>',
			'before_title' => '<h4 class="widgettitle">',
			'after_title' => '</h4>',
			)	
		);
				
		register_sidebar(
			array(
			'name' => __('[Header] High - Ads','hmth'),
			'id' => 'sidebar-5',
			'before_widget' => '<!-- %2$s --><span id="%1$s" class="header-high widget %2$s">',
			'after_widget' => '</span>',
			'before_title' => '<h4 class="widgettitle">',
			'after_title' => '</h4>',
			)
		);
		
		register_sidebar(
			array(
			'name' => __('[Header] Right -468 ads','hmth'),
			'id' => 'sidebar-6',
			'before_widget' => '<!-- %2$s --><div id="%1$s" class="header-right widget %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="widgettitle">',
			'after_title' => '</h4>',
			)
		);
		
		register_sidebar(
			array(
			'name' => __('[Header] Mid - ads','hmth'),
			'id' => 'header_mid',
			'before_widget' => '<!-- %2$s --><span id="%1$s" class="header-mid widget %2$s">',
			'after_widget' => '</span>',
			'before_title' => '<h4 class="widgettitle">',
			'after_title' => '</h4>',
			)
		);
		
		register_sidebar(
			array(
			'name' => __('[Header] Low - ads','hmth'),
			'id' => 'header_low',
			'before_widget' => '<!-- %2$s --><span id="%1$s" class="header-low widget %2$s">',
			'after_widget' => '</span>',
			'before_title' => '<h4 class="widgettitle">',
			'after_title' => '</h4>',
			)
		);
				
		register_sidebar(
			array(
			'name' => __('[All Content] Above - ads','hmth'),
			'id' => 'sidebar-7',
			'before_widget' => '<!-- %2$s --><span id="%1$s" class="all-content-above widget %2$s">',
			'after_widget' => '</span>',
			'before_title' => '<h4 class="widgettitle">',
			'after_title' => '</h4>',
			)
		);
		
		register_sidebar(
			array(
			'name' => __('[All Content] Below - ads','hmth'),
			'id' => 'sidebar-8',
			'before_widget' => '<!-- %2$s --><span id="%1$s" class="all-content-below widget %2$s">',
			'after_widget' => '</span>',
			'before_title' => '<h4 class="widgettitle">',
			'after_title' => '</h4>',
			)
		);
			
		register_sidebar(
			array(
			'name' => __('[Content Item] Above - ads','hmth'),
			'id' => 'sidebar-9',
			'before_widget' => '<!-- %2$s --><span id="%1$s" class="content-item-above widget %2$s">',
			'after_widget' => '</span>',
			'before_title' => '<h4 class="widgettitle">',
			'after_title' => '</h4>',
			)
		);
			
		register_sidebar(
			array(
			'name' => __('[Content Item] Below - ads','hmth'),
			'id' => 'sidebar-10',
			'before_widget' => '<!-- %2$s --><span id="%1$s" class="content-item-below widget %2$s">',
			'after_widget' => '</span>',
			'before_title' => '<h4 class="widgettitle">',
			'after_title' => '</h4>',
			)
		);
			
		register_sidebar(
			array(
			'name' => __('[Content Item] Left - ads/std','hmth'),
			'id' => 'sidebar-11',
			'before_widget' => '<!-- %2$s --><li id="%1$s" class="content-item-left widget %2$s">',	
			'after_widget' => '</li>',	
			'before_title' => '<h4 class="widgettitle">',
			'after_title' => '</h4>',
			)
		);
			
		register_sidebar(
			array(
			'name' => __('[Content Item] Right - ads/std','hmth'),
			'id' => 'sidebar-12',
			'before_widget' => '<!-- %2$s --><li id="%1$s"  class="content-item-right widget %2$s">',	
			'after_widget' => '</li>',			
			'before_title' => '<h4 class="widgettitle">',
			'after_title' => '</h4>',
			)
		);
		
		register_sidebar(
			array(
			'name' => __('[Footer] Above - std','hmth'),
			'id' => 'footer_above',
			'before_widget' => '<!-- %2$s --><li id="%1$s" class="footer-above widget %2$s">',
			'after_widget' => '</li>',		
			'before_title' => '<h4 class="widgettitle">',
			'after_title' => '</h4>',
			)
		);
		
		register_sidebar(
			array(
			'name' => __('[Nav Bar] Pages - link','hmth'),
			'id' => 'nav_bar_pages',
			'before_widget' => '<!-- %2$s --><div id="%1$s" class="nav-bar-pages widget %2$s">',
			'after_widget' => '</div>',
			'before_title' => '',
			'after_title' => '',
			)
		);
		
		register_sidebar(
			array(
			'name' => __('[Nav Bar] Categories - link','hmth'),
			'id' => 'nav_bar_categories',
			'before_widget' => '<!-- %2$s --><div id="%1$s" class="nav-bar-categories widget %2$s">',
			'after_widget' => '</div>',
			'before_title' => '',
			'after_title' => '',
			)
		);
		
		register_sidebar(
			array(
			'name' => __('[Footer] - link','hmth'),
			'id' => 'topfooter',
			'before_widget' => '<!-- %2$s --><div id="%1$s" class="footer widget %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="widgettitle">',
			'after_title' => '</h4>',
			)
		);
		
		register_sidebar(
			array(
			'name' => __('[Sub Footer] - link','hmth'),
			'id' => 'subfooter',
			'before_widget' => '<!-- %2$s --><div id="%1$s" class="sub-footer widget %2$s">',
			'after_widget' => '</div>',
			'before_title' => '',
			'after_title' => '',
			)
		);
				
		register_sidebar(
			array(
			'name' => __('[Header] Lock - ads','hmth'),
			'id' => 'header_lock',
			'before_widget' => '<!-- %2$s --><span id="%1$s" class="header-lock widget %2$s">',
			'after_widget' => '</span>',
			'before_title' => '<h4 class="widgettitle">',
			'after_title' => '</h4>',
			)
		);
		
		register_sidebar(
			array(
			'name' => __('[Sub Header] Lock - ads','hmth'),
			'id' => 'sub_header_lock',
			'before_widget' => '<!-- %2$s --><span id="%1$s" class="sub-header-lock widget %2$s">',
			'after_widget' => '</span>',
			'before_title' => '<h4 class="widgettitle">',
			'after_title' => '</h4>',
			)
		);
		
		register_sidebar(
			array(
			'name' => __('[Footer] Lock - ads','hmth'),
			'id' => 'footer_lock',
			'before_widget' => '<!-- %2$s --><span id="%1$s" class="footer-lock widget %2$s">',
			'after_widget' => '</span>',
			'before_title' => '<h4 class="widgettitle">',
			'after_title' => '</h4>',
			)
		);
		
		register_sidebar(
			array(
			'name' => __('[Sub Footer] Lock - ads','hmth'),
			'id' => 'sub_footer_lock',
			'before_widget' => '<!-- %2$s --><span id="%1$s" class="sub-footer-lock widget %2$s">',
			'after_widget' => '</span>',
			'before_title' => '<h4 class="widgettitle">',
			'after_title' => '</h4>',
			)
		);	
	}
}
?>