<?php 
/* 
This file is part of HeatMap Theme Pro v5
Copyright: Stuart Wider
Website: HeatMapTheme.com
*/
?>

<!--
common.php
~~~~~~~~~~~~~~~~~~~~~~~~ ~~~ -->

<?php
global $this_is_a_blog_page,$ids;
global $ads_already_shown;
global $all_content_above_already_shown;
?>

<!--
The Posts 
~~~~~~~~~~~~~~~~~~~~~~~~ ~~~ -->

	<?php $first_time_through=TRUE; 	/* This is set so that ads are only around the first post */ ?>
	
	<?php if (have_posts()) : while (have_posts()) : the_post(); ?>	
<!--
Individual Post Content 
~~~ -->

	<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>> 

		<div class="post-content">
<!--
Widget Area: [All Content] Above 
~~~ -->
			<?php 
if( ! isset($ads_already_shown) )
{
    $ads_already_shown = "";
}
if(! isset($all_content_above_already_shown))
{
	$all_content_above_already_shown="";
}
            if ($first_time_through) {
                if ( !$ads_already_shown && !$all_content_above_already_shown) { 	// check to see if the ads have already been shown due to the use of the featured page option 
    
                    if (hmt_is_sidebar_active('sidebar-7')):
                    ?>
                        
                        <div id="all-content-above">
                        
                            <span class="all-content-above-widget-block">
                                <?php dynamic_sidebar('sidebar-7'); ?>
                            </span>
                        
                        </div> <!-- id="all-content-above" -->
                        <div class="clearFloat"></div>
                    
                    <?php
                    endif;
    
                }
            }
            ?>
    
            <?php
            if (!hmt4_get_option('hmt_inline_blog_titles')) {
            ?>
<!--
The Post Title 
~~~ -->	    
				<?php 
                if (hmt4_get_option('hmt_underline_post_titles')) {
                    if ((is_home() && ($first_time_through) && (!hmt4_get_option('hmt_featured')))
                        || (!is_home() && ($first_time_through))
                        || ($this_is_a_blog_page && ($first_time_through)))
                    {
                    ?>
                        <h2 class="h2-simulate-h1-size-underline"><a href="<?php the_permalink(); ?>" rel="bookmark"><?php the_title(); ?></a></h2>
                    <?php
                    } else {
                    ?>
                        <h2 class="h2-simulate-h1-size"><a href="<?php the_permalink(); ?>" rel="bookmark"><?php the_title(); ?></a></h2>
                    <?php
                    }
                } else {
                ?>
                    <h2 class="h2-simulate-h1-size"><a href="<?php the_permalink(); ?>" rel="bookmark"><?php the_title(); ?></a></h2>
                <?php
                }
            }
            ?>
<!--
Widget Area: [Content Item] Above
~~~ -->	
			<?php 
            if ($first_time_through) if (!$ads_already_shown) {
                
                if (hmt_is_sidebar_active('sidebar-9')):
                ?>
                    
                    <div id="content-item-above">
                    
                        <span class="content-item-above-widget-block">
                            <?php dynamic_sidebar('sidebar-9'); ?>
                        </span>
                    
                    </div> <!-- id="content-item-above" -->
                
                <?php
                endif;
                ?>
<!--
Widget Area: [Content Item] Left 
~~~ -->
				<?php 
                if (hmt_is_sidebar_active('sidebar-11')):
                ?>
                    <div id="content-item-left">
                        
                        <ul>
                        <?php dynamic_sidebar('sidebar-11'); ?>
                        </ul>
                    
                    </div> <!-- id="content-item-left" -->
                <?php
                endif;
                ?>		
<!--
Widget Area: [Content Item] Right
~~~ -->
				<?php 
                if (hmt_is_sidebar_active('sidebar-12')):
                ?>
                    <div id="content-item-right">
                        
                        <ul>
                        <?php dynamic_sidebar('sidebar-12'); ?>
                        </ul>
                    
                    </div> <!-- id="content-item-right" -->
                <?php
                endif;
                ?>
                
                
            <?php	
            }		
            ?>	
            
            <?php
            if (hmt4_get_option('hmt_inline_blog_titles')) {
            ?>
<!--
The Post Title 
~~~ -->	    

                <h2 class="h2-simulate-h1-size"><a href="<?php the_permalink(); ?>" rel="bookmark"><?php the_title() ?></a></h2>
             
            <?php
            }
            ?>
                      	  
<!--
The content itself 
~~~ -->
			<?php 
            $temp_post = get_post($post->ID, ARRAY_A);					
            $ids[] = get_the_ID(); 										// grabs the id of the page so it can be excluded in the recent posts plus widget
            
            if (function_exists('has_post_thumbnail') && has_post_thumbnail()) {  //  okay so if this post has a thumbnail (as per wp 2.9 thumnail features) then do something about it
            
                if (hmt4_get_option('hmt_common_thumbnail_left_or_right')!='OFF') { // if thumbnails are set not to show then dont show them!
                    if (hmt4_get_option('hmt_common_thumbnail_left_or_right')=='RIGHT') print '<div class="common-page-thumbnail-right">'; // push the the thumbnail left or right depending on the options setting
                    else print '<div class="common-page-thumbnail-left">'; ?>		   
                    
                        


                    <a href="<?php if( get_post_meta($post->ID, "featured-img-link", true)){  echo get_post_meta($post->ID, "featured-img-link", true); } else { the_permalink(); } ?>" <?php if( get_post_meta($post->ID, "featured-img-link-nofollow", true)){  echo ' rel="nofollow" '; } ?> >
                        <?php
                        if ((is_archive())||is_search()) the_post_thumbnail('archive-image-size'); // show a smaller thumbnail if this is an archive - otherwise just show the regular sized thumbnail
                        else the_post_thumbnail('post-image-size');
                        ?>
                    </a>
                    </div>
            <?php 
                }
            }
             
          	$hmt_aff_link = '';
          	$hmt_aff_link_text = '';
	  		$afflink="";
	  		$affclass="";
          
          	if (get_post_meta($post->ID, "aff-link", true)) $hmt_aff_link = get_post_meta($post->ID, "aff-link", true);
          	if (get_post_meta($post->ID, "aff-link-text", true)) $hmt_aff_link_text = get_post_meta($post->ID, "aff-link-text", true);

            $more_text = get_post_meta($post->ID, "more-text", true);			// If you want to specify your own excerpt and 'more text' then you can do that.
			
			if ($hmt_aff_link_text && $hmt_aff_link) {
				$afflink='&nbsp;&nbsp;&nbsp;<span class="aff-link-button"><a  href="' . $hmt_aff_link . '" target="_blank" ';
				if( get_post_meta($post->ID, "aff-link-nofollow", true)){  $afflink.=' rel="nofollow" '; }
				$afflink.=' >' . $hmt_aff_link_text . '</a></span>';
				$affclass="-button";
			} 
						  
					if ($temp_post['post_excerpt']) {	// This code block gets the excerpt and more text from the custom fields,
						the_excerpt();
						echo '<p class="button-line"><span  class="more-link'.$affclass.' more-text-space"><a href="'; 	// or does something sensible if you havent specified them.
						the_permalink(); 
						echo '">';
						
						if ($more_text != '') 
							echo get_post_meta($post->ID, "more-text", true);
						else 
							_e('Read more...','hmth');
							
						print '</a></span>' . $afflink . '</p>';
					}
					else { 
						if ($more_text == '') $more_text = __('Read more...','hmth');
						
						$this_excerpt_length = hmt4_get_option('hmt_auto_excerpt_length');
						

						if (!$this_excerpt_length) {
							if ($affclass == "-button") {
								the_content(''); 
								print '<p class="button-line"><span  class="more-link'.$affclass.' more-text-space"><a href="'. get_permalink($post->ID) . '">' . $more_text . '</a></span>'.$afflink.'</p>'; 					 
							}
							else
							{ 
								the_content($more_text);
							}	
							
						}
						else {
							the_excerpt();
							if ($more_text != '') print '<p class="button-line"><span  class="more-link'.$affclass.' more-text-space"><a href="'. get_permalink($post->ID) . '">' . $more_text . '</a></span>'.$afflink.'</p>';
						}
					}
 

            ?>
           
            
            <?php edit_post_link(__('(Edit)','hmth'), '<p>', '</p>'); ?>
		

<!--
Widget Area: [Content Item] Below
~~~ -->
			<?php if ($first_time_through) if (!$ads_already_shown) {
            
                if (hmt_is_sidebar_active('sidebar-10')):
                ?>
                    <div id="content-item-below">
                    
                        <span class="content-item-below-widget-block">
                            <span class="content-item-below-widget-block">
                                <?php dynamic_sidebar('sidebar-10'); ?>
                            </span>
                        </span>
                        
                    </div> <!-- id="content-item-below" -->
                        
                    <?php
                    /* if (!hmt4_get_option('hmt_flow_blog_titles')) {  // this is here for adventurous types to try */
                    ?>	
                    <div class="clearFloat"></div>
                    <?php
                    /*} */
                    ?>	
    
                <?php 
                endif;
            }?>
        </div> <!-- class="post-content" -->
    
        <?php
        /* if (!hmt4_get_option('hmt_flow_blog_titles')) {  // this is here for adventurous types to try */
        ?>	
        <div class="clearFloat"></div>
        <?php
        /* } */
        ?>	

<!--
Individual Post Details 
~~~ -->

			<?php 
            /* logic to leave out post details according to the heatmap options set in the admin */
            $leave_out_details = false;
            
            if (hmt4_get_option('hmt_hide_details_for_home') && is_home()) $leave_out_details = true;	
            if (hmt4_get_option('hmt_hide_details_for_categories') && is_category()) $leave_out_details = true;	
            if (hmt4_get_option('hmt_hide_details_for_search') && is_search()) $leave_out_details = true;	
            if (hmt4_get_option('hmt_hide_details_for_archives') && is_archive()) $leave_out_details = true;	
            
            /* logic to leave out (or include) the comments # according to the heatap options */
            
            if(! isset($leave_out_comments))
            {
               $leave_out_comments="";
            }
            if (hmt4_get_option('hmt_hide_comments_for_home') && is_home()) $leave_out_comments = true;	
            if (hmt4_get_option('hmt_hide_comments_for_categories') && is_category()) $leave_out_comments = true;	
            if (hmt4_get_option('hmt_hide_comments_for_search') && is_search()) $leave_out_comments = true;	
            if (hmt4_get_option('hmt_hide_comments_for_archives') && is_archive()) $leave_out_comments = true;	
            
            if (!$leave_out_details) { /* if we are 'not' leaving out the details then show them! */
            ?>
        
                <div class="post-details">
                
                	<?php get_template_part('like-buttons'); ?>
            
                    <p class="comment-button-box">
                        <?php
                        $number_of_comments = get_comments_number();
                        if (($post->comment_status !='closed') || ($number_of_comments > 0)) {
                        ?>
                            <?php 
                            if (!$leave_out_comments) {
                            ?>
                                <span class="comment-button"><a href="<?php the_permalink();?>#respond"><?php comments_number(__('Be the first to comment','hmth'), __('1 comment','hmth'), __('% comments','hmth'));?></a><?php if ($post->comment_status != 'closed') { print ' - '; _e('What do you think?','hmth'); }?></span><br /> 
                            <?php 
                            }
                        }
                        ?>
      
                        <?php _e('Posted by','hmth'); ?>
                        <?php echo get_the_author(); ?>
                        <?php /* the_author_posts_link(); */ /*uncomment this if you actually want a link to the authors posts - it reveals the authors username though - or am I being too security concious? */?>
                         - 
                        <?php echo get_the_date();?>&nbsp;<?php _e('at','hmth'); ?>&nbsp;<?php the_time(); /* date and time format so that default system date and time is used instead of preset date and time */ ?> 
                    </p>
                    <p>
                    <?php _e('Categories','hmth'); ?>: 
                        <?php the_category(', ') ?>
                    &nbsp;&nbsp;<?php _e('Tags','hmth'); ?>:
                        <?php the_tags('') ?>
                    </p>
    
                </div> <!-- class="post-details" -->
        
            <?php
            }
            else if (!$leave_out_comments) { /* if we are 'not' leaving out the comments # then show them! */ ?> 
            
                <?php
                $number_of_comments = get_comments_number();
                if (($post->comment_status !='closed') || ($number_of_comments > 0)) {
                ?>
           
                    <div class="post-details nobg">
                    
                    <?php get_template_part('like-buttons'); ?>
                    
                        <p class="comment-button-box">
                            <span class="comment-button">
                                <a href="<?php the_permalink();?>#respond"><?php comments_number(__('Be the first to comment','hmth'), __('1 comment','hmth'), __('% comments','hmth'));?></a><?php if ($post->comment_status != 'closed'){ print ' - '; _e('What do you think?','hmth'); }?>
                            </span>
                        </p> 
                        
                    </div> <!-- class="post-details" -->
                    
            <?php
                }
            }
            else
            {?>
            <div class="post-divider">   <?php /* post divider to divide posts if post details are not showing */ ?>
                <hr/>
            </div> <!-- class="post-divider" -->
            <?php 
            } 
            ?>
        
            <?php $first_time_through=FALSE; ?> 
        
        </div> <!-- post_class -->
	
	<?php endwhile; 
		
	endif; ?>

	
<!--
End of common.php
~~~ -->