<?php 
/* 
This file is part of HeatMap Theme Pro v5
Copyright: Stuart Wider
Website: HeatMapTheme.com
*/
?>
<?php get_header(); ?>

<!-- 
archive.php
~~~~~~~~~~~~~~~~~~~~~~~~ ~~~ -->
		
<!--
Content of the page (inc comments and post details)
~~~~~~~~~~~~~~~~~~~~~~~~ ~~~ -->
<div id="page-body-wrapper">

	<div id="content">
		
		<div class="post-content">
<!--
Widget Area: [All Content] Above 
~~~ -->	

			<?php 
            if (hmt_is_sidebar_active('sidebar-7')):
            ?>
				
                <div id="all-content-above">
				
                    <span class="all-content-above-widget-block">
                        <?php dynamic_sidebar('sidebar-7'); ?>
                    </span>
                
                </div> <!-- id="all-content-above" -->
            
            <?php
			endif;
			?>
			
			<?php $all_content_above_already_shown = TRUE;	// Set the ads above the content to 'already shown' so that common.php doesnt double up and show the ad again ?>
		
			<?php if (have_posts()) : ?>

<!--
Format the title of the Archive
~~~ -->

			  <?php /* If this is a category archive */ if (is_category()) { ?>
				<h2 class="h2-simulate-h1-size-underline"><?php single_cat_title(); ?></h2>
				<div class="cat_desc"><?php echo category_description(); ?></div>
			  <?php /* If this is a tag archive */ } elseif( is_tag() ) { ?>
				<h2 class="h2-simulate-h1-size-underline "><?php _e('Posts tagged','hmth'); ?> "<?php single_tag_title(); ?>"</h2>
				<div class="tag_desc"><?php echo tag_description(); ?></div>
			  <?php /* If this is a daily archive */ } elseif (is_day()) { ?>
				<h2 class="h2-simulate-h1-size-underline"><?php _e('Archive for','hmth'); ?> <?php the_time('F jS, Y'); ?></h2>
			  <?php /* If this is a monthly archive */ } elseif (is_month()) { ?>
				<h2 class="h2-simulate-h1-size-underline"><?php _e('Archive for','hmth'); ?> <?php the_time('F, Y'); ?></h2>
			  <?php /* If this is a yearly archive */ } elseif (is_year()) { ?>
				<h2 class="h2-simulate-h1-size-underline"><?php _e('Archive for','hmth'); ?> <?php the_time('Y'); ?></h2>
			  <?php /* If this is an author archive */ } elseif (is_author()) { ?>
				<h2 class="h2-simulate-h1-size-underline"><?php _e('Author Archive','hmth'); ?></h2>
			  <?php /* If this is a paged archive */ } elseif (isset($_GET['paged']) && !empty($_GET['paged'])) { ?>
				<h2 class="h2-simulate-h1-size-underline"><?php _e('Blog Archives','hmth'); ?></h2>
			  <?php } ?>
		  
			<?php else :

				if ( is_category() ) {  // If this is a category archive
					printf("<h2 class='h2-simulate-h1-size'>". __("Sorry, but there aren't any posts in the %s category yet.",'hmth')."</h2>",  single_cat_title('',false));
				} else if ( is_date() ) {  // If this is a date archive
					printf("<h2 class='h2-simulate-h1-size'>". __("Sorry, but there aren't any posts with this date.",'hmth'). "</h2>");
				} else if ( is_author() ) {  // If this is a category archive
					$userdata = get_userdatabylogin(get_query_var('author_name'));
					printf("<h2 class='h2-simulate-h1-size'>". __("Sorry, but there aren't any posts by %s yet.",'hmth'). "</h2>", $userdata->display_name);
				} else {
					echo("<h2 class='h2-simulate-h1-size'>" . _e('No posts found.','hmth') . "</h2>");
				}
	
			endif; ?> 
		  
		</div> <!-- class="post-content" -->
		
		<?php 	
		get_template_part("common"); 
		?>
        
<!--
Widget Area: [All Content] Below
~~~ -->
		<?php
        if (hmt_is_sidebar_active('sidebar-8')):
        ?>
            
            <div id="all-content-below">
            
                <span class="all-content-below-widget-block">
                    <?php dynamic_sidebar('sidebar-8'); ?>
                </span>
            
            </div> <!-- id="all-content-below" -->
        
        <?php
        endif;
        ?>     
        
        <div class="post-nav"><p><?php posts_nav_link(); ?></p></div>   
		
	</div> <!-- id="content" -->
	
	<?php 
	if (!hmt4_get_option('hmt_no_sidebars_mode')) { 
		get_sidebar(); 
	}
	?>
    
<!--
[Footer Above] Below
~~~~~~~~~~~~~~~~~~~~~~~~ ~~~ -->

	<?php 
    if (hmt_is_sidebar_active('footer_above')):
    ?>

        <div id="footer-above">
            <ul class="footer-above-widget-block">
            	<?php dynamic_sidebar('footer_above'); ?> 
            </ul>
        </div> <!-- id="footer-above" -->
            
        <div class="clearFloat"></div>
    
    <?php 
    endif;
    ?>
	
</div> <!-- id="page-body-wrapper" -->

<?php get_footer(); ?>
	

	
<!--
End of archive.php
~~~ -->