<?php
/**
 * Plugin Name: WP Backlink Machine
 * Plugin URI: https://backlinkmachine.com/
 * Description: Get Backlinks to your WordPress site automatically
 * Author: Ankur Shukla
   Version: 1.80
 * Author URI: http://ankurshukla.com
*/

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

define( 'WPBLMACHINE_VERSION', '1.80' );
if (!isset($wp_version))
    global $wp_version;
define( 'WPBLMACHINE_WPVERSION', $wp_version );

define( 'WPBLMACHINE_DEBUG_MODE', 0 );

define( 'WPBLMACHINE_PLUGIN_NAME', dirname(plugin_basename(__FILE__) ));
define( 'WPBLMACHINE_DIR', plugin_dir_path( __FILE__ ) );
define( 'WPBLMACHINE_URL', plugins_url( WPBLMACHINE_PLUGIN_NAME ) );

include WPBLMACHINE_DIR.'/lib/common.php';
include WPBLMACHINE_DIR.'/lib/api.php';
if ( is_admin() ) {
	include WPBLMACHINE_DIR.'/lib/view.php';
	include WPBLMACHINE_DIR.'/lib/ui.php';
	include WPBLMACHINE_DIR.'/lib/styles/dashboard.php';
}

register_activation_hook ( __FILE__, 'wpblmachine_activation' );

/* Automatic Updates */
require WPBLMACHINE_DIR.'/lib/plugin-updates/plugin-update-checker.php';
$vidprofits_update_checker = new Puc_v4p1_Plugin_UpdateChecker(
    'https://backlinkmachine.s3.amazonaws.com/plugin-updates/1-std/info_blmachine1.json',
    WPBLMACHINE_DIR.WPBLMACHINE_PLUGIN_NAME.'.php'
);
?>